Option Explicit
Const scriptName = "Faded Edge"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - July 26, 2002 - MJM - Inital version.



' Script constants, questions, and error messages.
Const errNoSelection = "This script requires a text selection."




'Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim TextSel
If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

If errNum = 0 Then
  On Error Resume Next
  Set TextSel = CreatorApp.TextSelection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  Elseif TextSel.CharacterRuns.Count < 1 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  Elseif TextSel.Start > TextSel.End Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  End If
End If

' Whew!  User Interface Section Done.
If errNum = 0 Then
  Dim charRun, newColorSpec, newColor, newShade
  Dim selStart, selEnd
  selStart = TextSel.Start
  selEnd = TextSel.End
  
  For Each charRun In TextSel.CharacterRuns
    Set newColorSpec = charRun.Color
    newColor = newColorSpec.Name
    If newColor = "White" Then
      newColor = "Black"
    End If

    If charRun.Start < selStart Then
      charRun.Start = selStart
    End If
    If charRun.End > selEnd Then
      charRun.End = selEnd
    End If
    
    charRun.Outline = True
    charRun.Shadow = True
 
    charRun.Color = newColor
    charRun.Shade = 70
    
    charRun.FillColor = newColor
    charRun.FillShade = 100
    
    charRun.ShadowColor = newColor
    charRun.ShadowShade = 40
    
    charRun.OutlineWeight = 6
    
    charRun.ShadowHorizontalOffset = 0
    charRun.ShadowVerticalOffset = 0
    charRun.ShadowSkew = 0
    charRun.ShadowVerticalScale = 100
    charRun.ShadowOutset = 6
  Next
End If




